//
//  MCFileTransferEndpoint.h
//  SyncClient
//
//  Created by Patrick Rogers on 03/04/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <MCNetComm/MCEndpoint.h>

@class MCZlibStreamProcessor;
@class MCProtocolState;
@class MCProtocolStateMachine;

extern NSString *MCFileTransferEndpointErrorDomain;
typedef enum {
	MCFileTransferEndpointCouldNotCreateOutputFileError,
	MCFileTransferEndpointCouldNotOpenOutputFileError,
} MCFileTransferEndpointErrors;

extern NSString *MCFileTransferEndpointBeginTransferNotifcation;
extern NSString *MCFileTransferEndpointProgressUpdateNotifcation;
extern NSString *MCFileTransferEndpointTransferCanceledNotifcation;
extern NSString *MCFileTransferEndpointEndTransferNotifcation;

extern NSString *MCFileTransferEndpointOperationCompleteNotifcation;

// kMCFileTransferPrefix
extern NSString *kMCFileTransferSizeKey;
extern NSString *kMCFileHashKey;
extern NSString *kMCFileIsCompressedKey;

// kMCFileTransferOffset
extern NSString *kMCFileOffsetStartKey;

// kMCFileTransferContent
extern NSString *kMCFileBytesChunkKey;

// kMCFileTransferResult
extern NSString *kMCFileTransferResultKey;

// File transfer message names
extern NSString *kMCFileTransferPrefix;  // Payload includes length of compressed file and hash of uncompressed file
extern NSString *kMCFileTransferOffset;  // Payload includes byte offset to start from
extern NSString *kMCFileTransferChunk;   // Payload includes chunk of bytes up to the maximum chunk size
extern NSString *kMCFileTransferComplete; // No payload
extern NSString *kMCFileTransferResult;  // Payload is a boolean result code


extern NSString *MCFileTransferEndpointProgressValueKey;
extern NSString *MCFileTransferEndpointTagValueKey;
extern NSString *MCFileTransferEndpointIsCompressedValueKey;
extern NSString *MCFileTransferEndpointIsUploadValueKey;
extern NSString *MCFileTransferEndpointWorkingPathValueKey;
extern NSString *MCFileTransferEndpointBytesTransferedValueKey;
extern NSString *MCFileTransferEndpointTotalBytesToSendKey;

extern NSString *MCFileTransferEndpointSuccessValueKey;

@interface MCFileTransferEndpoint : MCEndpoint {
	BOOL              copyOnUpload;           // before uploading, make a copy; defaults to YES (may change in future)
	int				  transferTag;			  // An identifier that describes the type of file being transferred

	NSString          *workingPath;           // During an upload or download the path to the working file
	BOOL              fileTransferIsCompressed; // During an upload or download true if the file is compressed
	
	NSFileHandle      *inputFile;             // During an upload the filehandle to read bytes from
	unsigned long long totalTransferSize;     // During an upload or download the total number of bytes to transfer
	
	MCZlibStreamProcessor *streamCompressor; // During an upload or download the stream compressor that is processing the file
	
	NSFileHandle      *outputFile;            // During a download the filehandle to write bytes to
	unsigned long long downloadedBytes;        // During a download, the total number of bytes downloaded
	NSData            *downloadHashCode;      // During a download the hash code of the final file
	
	MCProtocolStateMachine *fileTransferProtocolStateMachine;  // The state machine to use during a file transfer operation
	MCProtocolStateMachine *previousStateMachine;              // The state machine to restore at the end of a file transfer operation
}

#if MAC_OS_X_VERSION_MAX_ALLOWED <= MAC_OS_X_VERSION_10_4
- (BOOL)copyOnUpload;
- (void)setCopyOnUpload:(BOOL)flag;
#else
@property (readwrite) BOOL copyOnUpload;
#endif

#pragma mark -
#pragma mark Transfer Initiation Methods

- (void)beginUploadFromPath:(NSString *)inputPath withTag:(int)tag compressTransfer:(BOOL)compress;
- (void)beginDownloadToPath:(NSString *)outputPath withTag:(int)tag;

#pragma mark - 
#pragma mark Transfer Status Methods

- (BOOL)partialDownloadForPath:(NSString *)inputPath;
- (void)deletePartialDownloadForPath:(NSString *)inputPath;

#pragma mark -
#pragma mark Derived class notification methods

- (void)fileUploadDidFinish:(NSString *)uploadPath transferResult:(BOOL)transferResult tag:(int)tag;
- (void)fileDownloadDidFinish:(NSString *)uploadPath transferResult:(BOOL)transferResult tag:(int)tag;
@end
